/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.cmd.NamingStrategy;
import de.kosit.validationtool.impl.tasks.CheckAction;
import java.nio.file.Path;
import lombok.Generated;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SerializeReportAction
implements CheckAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SerializeReportAction.class);
    private final Path outputDirectory;
    private final Processor processor;
    private final NamingStrategy namingStrategy;

    @Override
    public void check(CheckAction.Bag results) {
        Path file = this.outputDirectory.resolve(this.namingStrategy.createName(results.getName()));
        try {
            log.info("Serializing result to {}", (Object)file.toAbsolutePath());
            Serializer serializer = this.processor.newSerializer(file.toFile());
            serializer.serializeNode(results.getReport());
        }
        catch (SaxonApiException e) {
            log.error("Can not serialize result report to {}", (Object)file.toAbsolutePath(), (Object)e);
        }
    }

    @Override
    public boolean isSkipped(CheckAction.Bag results) {
        if (results.getReport() == null) {
            log.warn("Can not serialize result report. No document found");
            return true;
        }
        return false;
    }

    @Generated
    public SerializeReportAction(Path outputDirectory, Processor processor, NamingStrategy namingStrategy) {
        this.outputDirectory = outputDirectory;
        this.processor = processor;
        this.namingStrategy = namingStrategy;
    }
}

