/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.api.InputFactory;
import de.kosit.validationtool.api.Result;
import de.kosit.validationtool.cmd.CheckAssertionAction;
import de.kosit.validationtool.cmd.CommandLineOptions;
import de.kosit.validationtool.cmd.DefaultNamingStrategy;
import de.kosit.validationtool.cmd.ExtractHtmlContentAction;
import de.kosit.validationtool.cmd.InternalCheck;
import de.kosit.validationtool.cmd.NamingStrategy;
import de.kosit.validationtool.cmd.PrintMemoryStats;
import de.kosit.validationtool.cmd.PrintReportAction;
import de.kosit.validationtool.cmd.ReturnValue;
import de.kosit.validationtool.cmd.SerializeReportAction;
import de.kosit.validationtool.cmd.SerializeReportInputAction;
import de.kosit.validationtool.cmd.assertions.Assertions;
import de.kosit.validationtool.cmd.assertions.ObjectFactory;
import de.kosit.validationtool.cmd.report.Line;
import de.kosit.validationtool.daemon.Daemon;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.EngineInformation;
import de.kosit.validationtool.impl.Printer;
import de.kosit.validationtool.impl.xml.ProcessorProvider;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.sf.saxon.s9api.Processor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.AnsiRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Validator.class);

    private Validator() {
    }

    static ReturnValue mainProgram(CommandLineOptions cmd) {
        ReturnValue returnValue;
        Validator.greeting();
        try {
            if (cmd.isDaemonModeEnabled()) {
                Validator.startDaemonMode(cmd);
                returnValue = ReturnValue.DAEMON_MODE;
            } else if (cmd.isCliModeEnabled() || Validator.isPiped()) {
                returnValue = Validator.processActions(cmd);
            } else {
                Printer.writeErr("No test target found", new Object[0]);
                returnValue = ReturnValue.CONFIGURATION_ERROR;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Printer.writeErr(e.getMessage(), new Object[0]);
            if (cmd.isDebugOutput()) {
                log.error(e.getMessage(), e);
            } else {
                log.error(e.getMessage());
            }
            return ReturnValue.CONFIGURATION_ERROR;
        }
        return returnValue;
    }

    private static void greeting() {
        Printer.writeOut("{0} version {1}", EngineInformation.getName(), EngineInformation.getVersion());
    }

    private static int determineThreads(CommandLineOptions.DaemonOptions cmd) {
        int threads = Runtime.getRuntime().availableProcessors();
        if (cmd.getWorkerCount() > 0) {
            threads = cmd.getWorkerCount();
        }
        return threads;
    }

    private static void startDaemonMode(CommandLineOptions cmd) {
        if (cmd.isCliModeEnabled()) {
            Printer.writeErr("Mixed mode configuration detected. Use either daemon mode or cli mode commandline options. They are mutual exclusive. Will ignore cli mode options", new Object[0]);
        }
        List<Configuration> configuration = Validator.getConfiguration(cmd);
        CommandLineOptions.DaemonOptions daemonOptions = cmd.getDaemonOptions();
        Daemon validDaemon = new Daemon(daemonOptions.getHost(), daemonOptions.getPort(), Validator.determineThreads(daemonOptions));
        validDaemon.setGuiEnabled(!daemonOptions.isDisableGUI());
        Printer.writeOut("\nStarting daemon mode ...", new Object[0]);
        validDaemon.startServer(ProcessorProvider.getProcessor(), configuration.toArray(new Configuration[configuration.size()]));
    }

    private static ReturnValue processActions(CommandLineOptions cmd) throws IOException {
        long start = System.currentTimeMillis();
        Processor processor = ProcessorProvider.getProcessor();
        List<Configuration> config = Validator.getConfiguration(cmd);
        InternalCheck check = new InternalCheck(processor, config.toArray(new Configuration[0]));
        CommandLineOptions.CliOptions cliOptions = ObjectUtils.getIfNull(cmd.getCliOptions(), new CommandLineOptions.CliOptions());
        Path outputDirectory = Validator.determineOutputDirectory(cliOptions);
        if (cliOptions.isExtractHtml()) {
            check.getCheckSteps().add(new ExtractHtmlContentAction(processor, outputDirectory));
        }
        check.getCheckSteps().add(new SerializeReportAction(outputDirectory, processor, Validator.determineNamingStrategy(cliOptions)));
        if (cliOptions.isSerializeInput()) {
            check.getCheckSteps().add(new SerializeReportInputAction(outputDirectory, check.getConversionService()));
        }
        if (cliOptions.isPrintReport()) {
            check.getCheckSteps().add(new PrintReportAction(processor));
        }
        if (cliOptions.getAssertions() != null) {
            Assertions assertions = Validator.loadAssertions(cliOptions.getAssertions());
            check.getCheckSteps().add(new CheckAssertionAction(assertions, processor));
        }
        if (cliOptions.isPrintMemoryStats()) {
            check.getCheckSteps().add(new PrintMemoryStats());
        }
        log.info("Setup completed in {}ms\n", (Object)(System.currentTimeMillis() - start));
        Collection<Input> targets = Validator.determineTestTargets(cliOptions);
        start = System.currentTimeMillis();
        HashMap<String, Result> results = new HashMap<String, Result>();
        Printer.writeOut("\nProcessing of {0} objects started", targets.size());
        long tick = System.currentTimeMillis();
        for (Input input : targets) {
            results.put(input.getName(), check.checkInput(input));
            if ((System.currentTimeMillis() - tick) / 1000L <= 5L) continue;
            tick = System.currentTimeMillis();
            Printer.writeOut("{0}/{1} objects processed", results.size(), targets.size());
        }
        long processingTime = System.currentTimeMillis() - start;
        Printer.writeOut("Processing of {0} objects completed in {1}ms", targets.size(), processingTime);
        check.printResults(results);
        log.info("Processing {} object(s) completed in {}ms", (Object)targets.size(), (Object)processingTime);
        return check.isSuccessful(results) ? ReturnValue.SUCCESS : ReturnValue.createFailed(check.getNotAcceptableCount(results));
    }

    private static List<Configuration> getConfiguration(CommandLineOptions cmd) {
        List scenarios = ObjectUtils.getIfNull(cmd.getScenarios(), Collections.emptyList());
        Map<String, Path> mappedScenarios = scenarios.stream().collect(Collectors.toMap(CommandLineOptions.Definition::getName, CommandLineOptions.Definition::getPath));
        List repos = ObjectUtils.getIfNull(cmd.getRepositories(), Collections.emptyList());
        Map<String, Path> mappedRepos = repos.stream().collect(Collectors.toMap(CommandLineOptions.Definition::getName, CommandLineOptions.Definition::getPath));
        Validator.checkUnused(mappedScenarios, mappedRepos);
        return mappedScenarios.entrySet().stream().map(e -> {
            Validator.assertFileExistance((Path)e.getValue(), "scenario");
            URI scenarioLocation = ((Path)e.getValue()).toUri();
            URI repositoryLocation = Validator.findRepository(scenarioLocation, (String)e.getKey(), mappedRepos);
            Validator.reportLoading(scenarioLocation, repositoryLocation);
            Configuration configuration = Configuration.load(scenarioLocation, repositoryLocation).build(ProcessorProvider.getProcessor());
            Validator.reportConfiguration(configuration);
            return configuration;
        }).collect(Collectors.toList());
    }

    private static void checkUnused(Map<String, Path> scenarios, Map<String, Path> repositories) {
        List<Map.Entry> unused = repositories.entrySet().stream().filter(e -> scenarios.get(e.getKey()) == null).collect(Collectors.toList());
        unused.removeIf(e -> ((String)e.getKey()).equals("default_1"));
        unused.forEach(e -> Printer.writeErr("Warning: repository definition \"{0}\" is not used", e.getKey()));
    }

    private static URI findRepository(URI scenarioLocation, String key, Map<String, Path> repositories) {
        Path path = repositories.getOrDefault(key, repositories.get("default_1"));
        if (path == null) {
            if (key.startsWith("default")) {
                return Paths.get(scenarioLocation).getParent().toUri();
            }
            throw new IllegalArgumentException(String.format("No repository location for scenario definition '%s' specified", key));
        }
        return Validator.determineRepository(path);
    }

    private static void reportLoading(URI scenarioLocation, URI repositoryLocation) {
        Printer.writeOut("Loading scenarios from  {0}", scenarioLocation);
        Printer.writeOut("Using repository  {0}", repositoryLocation);
        Printer.writeOut("", new Object[0]);
    }

    private static void reportConfiguration(Configuration configuration) {
        Printer.writeOut("Loaded \"{0}\" by {1} from {2} ", configuration.getName(), configuration.getAuthor(), configuration.getDate());
        Printer.writeOut("The following scenarios are available:", new Object[0]);
        configuration.getScenarios().forEach(e -> {
            Line line = new Line(AnsiRenderer.Code.GREEN);
            line.add("  * " + e.getName());
            Printer.writeOut(line.render(false, false), new Object[0]);
        });
        Printer.writeOut("", new Object[0]);
    }

    private static NamingStrategy determineNamingStrategy(CommandLineOptions.CliOptions cmd) {
        DefaultNamingStrategy namingStrategy = new DefaultNamingStrategy();
        if (StringUtils.isNotEmpty(cmd.getReportPrefix())) {
            namingStrategy.setPrefix(cmd.getReportPrefix());
        }
        if (StringUtils.isNotEmpty(cmd.getReportPostfix())) {
            namingStrategy.setPostfix(cmd.getReportPostfix());
        }
        return namingStrategy;
    }

    private static Assertions loadAssertions(Path p) {
        Assertions a = null;
        if (Files.exists(p, new LinkOption[0])) {
            ConversionService c = new ConversionService();
            c.initialize(ObjectFactory.class.getPackage());
            a = c.readXml(p.toUri(), Assertions.class);
        }
        return a;
    }

    private static Path determineOutputDirectory(CommandLineOptions.CliOptions cmd) {
        Path dir;
        if (cmd.getOutputPath() != null) {
            dir = cmd.getOutputPath();
            if (!Files.exists(dir, new LinkOption[0]) && !dir.toFile().mkdirs() || !Files.isDirectory(dir, new LinkOption[0])) {
                throw new IllegalStateException(String.format("Invalid target directory %s specified", dir.toString()));
            }
        } else {
            dir = Paths.get("", new String[0]);
        }
        return dir;
    }

    private static Collection<Input> determineTestTargets(CommandLineOptions.CliOptions cmd) throws IOException {
        ArrayList<Input> targets = new ArrayList<Input>();
        if (cmd.getFiles() != null && !cmd.getFiles().isEmpty()) {
            cmd.getFiles().forEach(e -> targets.addAll(Validator.determineTestTarget(e)));
        }
        if (Validator.isPiped()) {
            targets.add(Validator.readFromPipe());
        }
        if (targets.isEmpty()) {
            throw new IllegalStateException("No test targets found. Nothing to check. Will quit now!");
        }
        return targets;
    }

    private static boolean isPiped() throws IOException {
        return System.in.available() > 0;
    }

    private static Input readFromPipe() {
        return InputFactory.read(System.in, "stdin");
    }

    private static Collection<Input> determineTestTarget(Path d) {
        if (Files.isDirectory(d, new LinkOption[0])) {
            return Validator.listDirectoryTargets(d);
        }
        if (Files.exists(d, new LinkOption[0])) {
            return Collections.singleton(InputFactory.read(d));
        }
        log.warn("The specified test target {} does not exist. Will be ignored", (Object)d);
        return Collections.emptyList();
    }

    private static Collection<Input> listDirectoryTargets(Path d) {
        Collection collection;
        block8: {
            Stream<Path> stream = Files.list(d);
            try {
                collection = stream.filter(path -> path.toString().toLowerCase().endsWith(".xml")).map(InputFactory::read).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("IOException while list directory content. Can not determine test targets.", e);
                }
            }
            stream.close();
        }
        return collection;
    }

    private static URI determineRepository(Path d) {
        if (Files.isDirectory(d, new LinkOption[0])) {
            return d.toUri();
        }
        throw new IllegalArgumentException(String.format("Not a valid path for repository definition specified: '%s'", d.toAbsolutePath()));
    }

    private static void assertFileExistance(Path f, String type) {
        if (!Files.isRegularFile(f, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Not a valid path for %s definition specified: '%s'", type, f.toAbsolutePath()));
        }
    }
}

