/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.config;

import de.kosit.validationtool.config.Builder;
import de.kosit.validationtool.impl.ContentRepository;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.model.scenarios.ResourceType;
import de.kosit.validationtool.model.scenarios.ValidateWithXmlSchema;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import javax.xml.validation.Schema;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaBuilder
implements Builder<Pair<ValidateWithXmlSchema, Schema>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaBuilder.class);
    private static final String DEFAULT_NAME = "manually configured";
    private Schema schema;
    private URI schemaLocation;
    private String name;

    @Override
    public Result<Pair<ValidateWithXmlSchema, Schema>, String> build(ContentRepository repository) {
        Result<Pair<ValidateWithXmlSchema, Schema>, String> result;
        if (this.schema == null && this.schemaLocation == null) {
            return SchemaBuilder.createError(String.format("Must supply source location and/or executable for schema '%s'", this.name));
        }
        try {
            if (this.schema == null) {
                this.schema = repository.createSchema(this.schemaLocation);
            }
            result = new Result<Pair<ValidateWithXmlSchema, Schema>, String>(new ImmutablePair<ValidateWithXmlSchema, Schema>(this.createObject(), this.schema));
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage(), e);
            result = SchemaBuilder.createError(String.format("Can not create schema based %s. Exception is %s", this.schemaLocation, e.getMessage()));
        }
        return result;
    }

    private ValidateWithXmlSchema createObject() {
        ValidateWithXmlSchema o = new ValidateWithXmlSchema();
        ResourceType r = new ResourceType();
        r.setName(ObjectUtils.isNotEmpty(this.name) ? this.name : DEFAULT_NAME);
        r.setLocation(this.schemaLocation != null ? this.schemaLocation.toASCIIString() : "manuelly configured");
        o.getResource().add(r);
        return o;
    }

    private static Result<Pair<ValidateWithXmlSchema, Schema>, String> createError(String msg) {
        return new Result<Object, String>(null, Collections.singletonList(msg));
    }

    public SchemaBuilder schema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public SchemaBuilder schemaLocation(URI schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    public SchemaBuilder schemaLocation(String schemaLocation) {
        return this.schemaLocation(URI.create(schemaLocation));
    }

    public SchemaBuilder schemaLocation(Path schemaLocation) {
        return this.schemaLocation(schemaLocation.toUri());
    }

    public SchemaBuilder name(String name) {
        this.name = name;
        return this;
    }
}

