/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.daemon;

import com.sun.net.httpserver.HttpExchange;
import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.daemon.BaseHandler;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.EngineInformation;
import de.kosit.validationtool.model.daemon.ApplicationType;
import de.kosit.validationtool.model.daemon.HealthType;
import de.kosit.validationtool.model.daemon.MemoryType;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HealthHandler
extends BaseHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthHandler.class);
    private final List<Configuration> scenarios;
    private final ConversionService conversionService;

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        HealthType health = this.createHealth();
        String xml = this.conversionService.writeXml(health);
        HealthHandler.write(httpExchange, xml.getBytes(), "application/xml");
    }

    private HealthType createHealth() {
        HealthType h = new HealthType();
        h.setMemory(HealthHandler.createMemory());
        h.setApplication(HealthHandler.createApplication());
        h.setStatus(this.scenarios.stream().mapToLong(c -> c.getScenarios().size()).sum() > 0L ? "UP" : "DOWN");
        return h;
    }

    private static MemoryType createMemory() {
        MemoryType m = new MemoryType();
        Runtime runtime = Runtime.getRuntime();
        m.setFreeMemory(runtime.freeMemory());
        m.setMaxMemory(runtime.maxMemory());
        m.setTotalMemory(runtime.totalMemory());
        return m;
    }

    private static ApplicationType createApplication() {
        ApplicationType a = new ApplicationType();
        a.setBuild(EngineInformation.getBuild());
        a.setName(EngineInformation.getName());
        a.setVersion(EngineInformation.getVersion());
        return a;
    }

    @Generated
    public HealthHandler(List<Configuration> scenarios, ConversionService conversionService) {
        this.scenarios = scenarios;
        this.conversionService = conversionService;
    }
}

