/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class HtmlExtractor {
    private final Processor processor;
    private XPathExecutable executable;

    public List<XdmNode> extract(XdmNode xdmSource) {
        try {
            XPathSelector selector = this.getSelector();
            selector.setContextItem(xdmSource);
            return selector.stream().map(HtmlExtractor::castToNode).collect(Collectors.toList());
        }
        catch (SaxonApiException e) {
            throw new IllegalStateException("Can not extract html content", e);
        }
    }

    private static XdmNode castToNode(XdmItem xdmItem) {
        return (XdmNode)xdmItem;
    }

    private XPathSelector getSelector() {
        if (this.executable == null) {
            HashMap<String, String> ns = new HashMap<String, String>();
            ns.put("html", "http://www.w3.org/1999/xhtml");
            this.executable = this.createXPath("//html:html", ns);
        }
        return this.executable.load();
    }

    private XPathExecutable createXPath(String expression, Map<String, String> namespaces) {
        try {
            XPathCompiler compiler = this.processor.newXPathCompiler();
            if (namespaces != null) {
                namespaces.forEach(compiler::declareNamespace);
            }
            return compiler.compile(expression);
        }
        catch (SaxonApiException e) {
            throw new IllegalStateException(String.format("Can not compile xpath match expression '%s'", StringUtils.isNotBlank(expression) ? expression : "EMPTY EXPRESSION"), e);
        }
    }

    private String convertToString(XdmNode element) {
        try {
            StringWriter writer = new StringWriter();
            Serializer serializer = this.processor.newSerializer(writer);
            serializer.serializeNode(element);
            return writer.toString();
        }
        catch (SaxonApiException e) {
            throw new IllegalStateException("Can not convert to string", e);
        }
    }

    public List<String> extractAsString(XdmNode node) {
        return this.extract(node).stream().map(this::convertToString).collect(Collectors.toList());
    }

    public List<Element> extractAsElement(XdmNode node) {
        return this.extract(node).stream().map(HtmlExtractor::convertToElement).collect(Collectors.toList());
    }

    private static Element convertToElement(XdmNode xdmItem) {
        return (Element)((Object)NodeOverNodeInfo.wrap(xdmItem.getUnderlyingNode()));
    }

    @Generated
    public HtmlExtractor(Processor processor) {
        this.processor = processor;
    }
}

