/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.cmd.CommandLineOptions;
import de.kosit.validationtool.cmd.ReturnValue;
import de.kosit.validationtool.cmd.report.Line;
import de.kosit.validationtool.impl.Printer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiRenderer;
import picocli.CommandLine;

public class CommandLineApplication {
    private CommandLineApplication() {
    }

    public static void main(String[] args) {
        AnsiConsole.systemInstall();
        ReturnValue resultStatus = CommandLineApplication.mainProgram(args);
        if (!resultStatus.equals(ReturnValue.DAEMON_MODE)) {
            if (!resultStatus.equals(ReturnValue.HELP_REQUEST) && resultStatus.getCode() >= 0) {
                CommandLineApplication.sayGoodby(resultStatus);
            }
            System.exit(resultStatus.getCode());
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Printer.writeOut("Shutting down daemon ...", new Object[0])));
        }
    }

    private static void sayGoodby(ReturnValue resultStatus) {
        Printer.writeOut("\n##############################", new Object[0]);
        if (resultStatus.equals(ReturnValue.SUCCESS)) {
            Printer.writeOut("#   " + new Line(AnsiRenderer.Code.GREEN).add("Validation successful!").render(false, false) + "   #", new Object[0]);
        } else {
            Printer.writeOut("#     " + new Line(AnsiRenderer.Code.RED).add("Validation failed!").render(false, false) + "     #", new Object[0]);
        }
        Printer.writeOut("##############################", new Object[0]);
    }

    static ReturnValue mainProgram(String[] args) {
        ReturnValue resultStatus;
        CommandLine commandLine = new CommandLine((Object)new CommandLineOptions());
        try {
            commandLine.setExecutionExceptionHandler(CommandLineApplication::logExecutionException);
            int cmdlineRetVal = commandLine.execute(args);
            if (commandLine.isUsageHelpRequested() || cmdlineRetVal == 2) {
                resultStatus = ReturnValue.HELP_REQUEST;
            } else {
                resultStatus = (ReturnValue)ObjectUtils.getIfNull((Object)((ReturnValue)commandLine.getExecutionResult()), (Object)ReturnValue.PARSING_ERROR);
                if (resultStatus.isError()) {
                    commandLine.usage(System.out);
                }
            }
        }
        catch (Exception e) {
            Printer.writeErr("Error processing command line arguments: {0}", e.getMessage(), e);
            resultStatus = ReturnValue.PARSING_ERROR;
        }
        return resultStatus;
    }

    private static int logExecutionException(Exception ex, CommandLine cli, CommandLine.ParseResult parseResult) {
        String message = StringUtils.isNotEmpty((CharSequence)ex.getMessage()) ? ex.getMessage() : "Es ist eine Fehler aufgetreten";
        Printer.writeErr(ex, message, new Object[0]);
        return 1;
    }

    static enum Level {
        INFO,
        WARN,
        DEBUG,
        TRACE,
        ERROR,
        OFF;

    }
}

