/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.cmd.CommandLineOptions;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

class TypeConverter {
    static final Map<Class<?>, AtomicInteger> counter = new HashMap();

    TypeConverter() {
    }

    private static String getDefaultName(Class<?> type) {
        AtomicInteger current = counter.computeIfAbsent(type, a -> new AtomicInteger(1));
        return "default_" + current.getAndIncrement();
    }

    private static <T extends CommandLineOptions.Definition> T convert(Class<T> type, String value) {
        T def;
        String[] splitted = ((String)StringUtils.defaultIfBlank((CharSequence)value, (CharSequence)"")).split("=");
        if (splitted.length == 1) {
            def = TypeConverter.createNewInstance(type);
            ((CommandLineOptions.Definition)def).setName(TypeConverter.getDefaultName(type));
            ((CommandLineOptions.Definition)def).setPath(Paths.get(splitted[0].trim(), new String[0]));
        } else if (splitted.length == 2) {
            def = TypeConverter.createNewInstance(type);
            ((CommandLineOptions.Definition)def).setName(splitted[0].trim());
            ((CommandLineOptions.Definition)def).setPath(Paths.get(splitted[1].trim(), new String[0]));
        } else {
            throw new IllegalArgumentException("Not a valid repository specification " + value);
        }
        return def;
    }

    private static <T extends CommandLineOptions.Definition> T createNewInstance(Class<T> type) {
        try {
            return (T)((CommandLineOptions.Definition)type.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Error creating instance of type " + type);
        }
    }

    public static class ScenarioConverter
    implements CommandLine.ITypeConverter<CommandLineOptions.ScenarioDefinition> {
        public CommandLineOptions.ScenarioDefinition convert(String value) throws Exception {
            return (CommandLineOptions.ScenarioDefinition)TypeConverter.convert(CommandLineOptions.ScenarioDefinition.class, value);
        }
    }

    public static class RepositoryConverter
    implements CommandLine.ITypeConverter<CommandLineOptions.RepositoryDefinition> {
        public CommandLineOptions.RepositoryDefinition convert(String value) throws Exception {
            return (CommandLineOptions.RepositoryDefinition)TypeConverter.convert(CommandLineOptions.RepositoryDefinition.class, value);
        }
    }
}

