/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.config;

import de.kosit.validationtool.config.Builder;
import de.kosit.validationtool.impl.ContentRepository;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.model.scenarios.CreateReportType;
import de.kosit.validationtool.model.scenarios.ResourceType;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import lombok.Generated;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
implements Builder<Pair<CreateReportType, Scenario.Transformation>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String DEFAULT_NAME = "manually created report";
    private XsltExecutable executable;
    private URI source;
    private String name;

    @Override
    public Result<Pair<CreateReportType, Scenario.Transformation>, String> build(ContentRepository repository) {
        Result<Object, Object> result;
        if (this.executable == null && this.source == null) {
            return ReportBuilder.createError(String.format("Must supply source location and/or executable for report '%s'", this.name));
        }
        CreateReportType object = this.createObject();
        try {
            if (this.executable == null) {
                this.executable = repository.createTransformation(object.getResource()).getExecutable();
            }
            result = new Result(new ImmutablePair((Object)object, (Object)new Scenario.Transformation(this.executable, object.getResource())));
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage(), (Throwable)e);
            result = ReportBuilder.createError(String.format("Can not create report configuration based on %s. Exception is %s", this.source, e.getMessage()));
        }
        return result;
    }

    private CreateReportType createObject() {
        CreateReportType o = new CreateReportType();
        ResourceType r = new ResourceType();
        r.setLocation(this.source.toASCIIString());
        r.setName(ObjectUtils.isNotEmpty((Object)this.name) ? this.name : DEFAULT_NAME);
        o.setResource(r);
        return o;
    }

    private static Result<Pair<CreateReportType, Scenario.Transformation>, String> createError(String msg) {
        return new Result<Object, String>(null, Collections.singletonList(msg));
    }

    public ReportBuilder source(String source) {
        return this.source(URI.create(source));
    }

    public ReportBuilder source(URI source) {
        this.source = source;
        return this;
    }

    public ReportBuilder source(Path source) {
        return this.source(source.toUri());
    }

    public ReportBuilder name(String name) {
        this.name = name;
        return this;
    }
}

