/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.daemon;

import com.sun.net.httpserver.HttpExchange;
import de.kosit.validationtool.api.Check;
import de.kosit.validationtool.api.InputFactory;
import de.kosit.validationtool.api.Result;
import de.kosit.validationtool.daemon.BaseHandler;
import de.kosit.validationtool.impl.input.SourceInput;
import de.kosit.validationtool.impl.input.StreamHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CheckHandler
extends BaseHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckHandler.class);
    private static final AtomicLong counter = new AtomicLong(0L);
    private final Check implemenation;
    private final Processor processor;

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            log.debug("Incoming request");
            String requestMethod = httpExchange.getRequestMethod();
            if (requestMethod.equals("POST")) {
                BufferedInputStream buffered = StreamHelper.wrapPeekable(httpExchange.getRequestBody());
                if (!CheckHandler.isMultipartFormData(httpExchange) && CheckHandler.isContentAvailable(httpExchange, buffered)) {
                    SourceInput serverInput = (SourceInput)InputFactory.read(buffered, CheckHandler.resolveInputName(httpExchange.getRequestURI()));
                    Result result = this.implemenation.checkInput(serverInput);
                    CheckHandler.write(httpExchange, this.serialize(result), "application/xml", CheckHandler.resolveStatus(result));
                } else {
                    CheckHandler.error(httpExchange, 400, "No content supplied");
                }
            } else {
                CheckHandler.error(httpExchange, 405, "Method not supported");
            }
        }
        catch (Exception e) {
            log.error("Error checking entity", (Throwable)e);
            CheckHandler.error(httpExchange, 500, "Internal error: " + e.getMessage());
        }
    }

    private static boolean isContentAvailable(HttpExchange httpExchange, BufferedInputStream buffered) throws IOException {
        String length = httpExchange.getRequestHeaders().getFirst("Content-length");
        if (StringUtils.isNumeric((CharSequence)length)) {
            return Integer.parseInt(length) > 0;
        }
        return CheckHandler.streamContainsContent(buffered);
    }

    private static boolean isMultipartFormData(HttpExchange httpExchange) {
        return httpExchange.getRequestHeaders().getFirst("Content-type").startsWith("multipart");
    }

    private static boolean streamContainsContent(BufferedInputStream requestBody) throws IOException {
        return requestBody.available() > 0;
    }

    private static String resolveInputName(URI requestURI) {
        String path = requestURI.getPath();
        if (path.equalsIgnoreCase("/")) {
            return "supplied_instance_" + counter.incrementAndGet();
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private static int resolveStatus(Result result) {
        if (result.isProcessingSuccessful()) {
            return result.isAcceptable() ? 200 : 406;
        }
        return 422;
    }

    private byte[] serialize(Result result) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Serializer serializer = this.processor.newSerializer((OutputStream)out);
            serializer.serializeNode(result.getReport());
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SaxonApiException e) {
                log.error("Error serializing result", e);
                throw new IllegalStateException("Can not serialize result", e);
            }
        }
        out.close();
        return byArray;
    }

    @Generated
    public CheckHandler(Check implemenation, Processor processor) {
        this.implemenation = implemenation;
        this.processor = processor;
    }
}

