/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.tasks;

import de.kosit.validationtool.api.AcceptRecommendation;
import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.model.reportInput.CreateReportInput;
import de.kosit.validationtool.model.reportInput.ProcessingError;
import de.kosit.validationtool.model.reportInput.XMLSyntaxError;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.io.FilenameUtils;

@FunctionalInterface
public interface CheckAction {
    public void check(Bag var1);

    default public boolean isSkipped(Bag results) {
        return false;
    }

    public static class Bag {
        private Result<Scenario, String> scenarioSelectionResult;
        private CreateReportInput reportInput;
        private XdmNode report;
        private boolean finished;
        private boolean stopped;
        private AcceptRecommendation acceptStatus = AcceptRecommendation.UNDEFINED;
        private Input input;
        private Result<XdmNode, XMLSyntaxError> parserResult;
        private Result<Integer, String> assertionResult;
        private Result<Boolean, XMLSyntaxError> schemaValidationResult;

        public Bag(Input input) {
            this(input, new CreateReportInput());
        }

        public Bag(Input input, CreateReportInput reportInput) {
            this.input = input;
            this.reportInput = reportInput;
        }

        public void stopProcessing(String error) {
            this.stopProcessing(Collections.singleton(error));
        }

        public void stopProcessing(Collection<String> errors) {
            this.stopped = true;
            if (this.reportInput.getProcessingError() == null) {
                this.reportInput.setProcessingError(new ProcessingError());
            }
            this.reportInput.getProcessingError().getError().addAll(errors);
        }

        public void addProcessingError(String msg) {
            this.stopProcessing(msg);
        }

        public String getName() {
            String fileName = this.getInput().getName().replaceAll(".*/|.*\\\\", "");
            return FilenameUtils.getBaseName((String)fileName);
        }

        @Generated
        public Result<Scenario, String> getScenarioSelectionResult() {
            return this.scenarioSelectionResult;
        }

        @Generated
        public CreateReportInput getReportInput() {
            return this.reportInput;
        }

        @Generated
        public XdmNode getReport() {
            return this.report;
        }

        @Generated
        public boolean isFinished() {
            return this.finished;
        }

        @Generated
        public boolean isStopped() {
            return this.stopped;
        }

        @Generated
        public AcceptRecommendation getAcceptStatus() {
            return this.acceptStatus;
        }

        @Generated
        public Input getInput() {
            return this.input;
        }

        @Generated
        public Result<XdmNode, XMLSyntaxError> getParserResult() {
            return this.parserResult;
        }

        @Generated
        public Result<Integer, String> getAssertionResult() {
            return this.assertionResult;
        }

        @Generated
        public Result<Boolean, XMLSyntaxError> getSchemaValidationResult() {
            return this.schemaValidationResult;
        }

        @Generated
        public void setScenarioSelectionResult(Result<Scenario, String> scenarioSelectionResult) {
            this.scenarioSelectionResult = scenarioSelectionResult;
        }

        @Generated
        public void setReport(XdmNode report) {
            this.report = report;
        }

        @Generated
        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        @Generated
        public void setStopped(boolean stopped) {
            this.stopped = stopped;
        }

        @Generated
        public void setAcceptStatus(AcceptRecommendation acceptStatus) {
            this.acceptStatus = acceptStatus;
        }

        @Generated
        public void setInput(Input input) {
            this.input = input;
        }

        @Generated
        public void setParserResult(Result<XdmNode, XMLSyntaxError> parserResult) {
            this.parserResult = parserResult;
        }

        @Generated
        public void setAssertionResult(Result<Integer, String> assertionResult) {
            this.assertionResult = assertionResult;
        }

        @Generated
        public void setSchemaValidationResult(Result<Boolean, XMLSyntaxError> schemaValidationResult) {
            this.schemaValidationResult = schemaValidationResult;
        }
    }
}

