/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.tasks;

import de.kosit.validationtool.impl.CollectingErrorEventHandler;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.tasks.CheckAction;
import de.kosit.validationtool.model.reportInput.CreateReportInput;
import de.kosit.validationtool.model.reportInput.ValidationResultsSchematron;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.transform.dom.DOMSource;
import lombok.Generated;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener2;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltTransformer;
import org.oclc.purl.dsdl.svrl.SchematronOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronValidationAction
implements CheckAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchematronValidationAction.class);
    private final ConversionService conversionService;

    private List<ValidationResultsSchematron> validate(CheckAction.Bag results, XdmNode document, Scenario scenario) {
        return scenario.getSchematronValidations().stream().map(v -> this.validate(scenario, results, document, (Scenario.Transformation)v)).collect(Collectors.toList());
    }

    private ValidationResultsSchematron validate(Scenario scenario, CheckAction.Bag results, XdmNode document, Scenario.Transformation validation) {
        ValidationResultsSchematron s = new ValidationResultsSchematron();
        s.setResource(validation.getResourceType());
        try {
            XsltTransformer transformer = validation.getExecutable().load();
            transformer.setURIResolver(scenario.getUriResolver());
            CollectingErrorEventHandler e = new CollectingErrorEventHandler();
            transformer.setMessageListener((MessageListener2)e);
            XdmDestination result = new XdmDestination();
            transformer.setDestination((Destination)result);
            transformer.setInitialContextNode(document);
            transformer.transform();
            ValidationResultsSchematron.Results r = new ValidationResultsSchematron.Results();
            r.setSchematronOutput(this.conversionService.readDocument(new DOMSource(NodeOverNodeInfo.wrap((NodeInfo)result.getXdmNode().getUnderlyingNode()).getOwnerDocument()), SchematronOutput.class));
            s.setResults(r);
        }
        catch (SaxonApiException e) {
            String msg = String.format("Error processing schematron validation %s. Error is %s", validation.getResourceType().getName(), e.getMessage());
            log.error(msg, (Throwable)e);
            results.addProcessingError(msg);
            s.setResults(SchematronValidationAction.createErrorResult());
        }
        return s;
    }

    private static ValidationResultsSchematron.Results createErrorResult() {
        ValidationResultsSchematron.Results r = new ValidationResultsSchematron.Results();
        r.setSchematronOutput(new SchematronOutput());
        return r;
    }

    @Override
    public void check(CheckAction.Bag results) {
        CreateReportInput report = results.getReportInput();
        List<ValidationResultsSchematron> validationResult = this.validate(results, results.getParserResult().getObject(), results.getScenarioSelectionResult().getObject());
        report.getValidationResultsSchematron().addAll(validationResult);
    }

    @Override
    public boolean isSkipped(CheckAction.Bag results) {
        return SchematronValidationAction.hasNoSchematrons(results.getScenarioSelectionResult().getObject()) || SchematronValidationAction.isSchemaInvalid(results);
    }

    private static boolean isSchemaInvalid(CheckAction.Bag results) {
        return results.getSchemaValidationResult() == null || results.getSchemaValidationResult().isInvalid();
    }

    private static boolean hasNoSchematrons(Scenario object) {
        return object.getSchematronValidations().isEmpty();
    }

    @Generated
    public SchematronValidationAction(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

