/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.tasks;

import de.kosit.validationtool.impl.CollectingErrorEventHandler;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.impl.tasks.CheckAction;
import de.kosit.validationtool.model.reportInput.XMLSyntaxError;
import javax.xml.validation.Schema;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateReportInputAction
implements CheckAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateReportInputAction.class);
    private final ConversionService conversionService;
    private final Schema schema;

    @Override
    public void check(CheckAction.Bag bag) {
        Result<Boolean, XMLSyntaxError> results = this.validate(bag.getReportInput());
        if (!results.isValid()) {
            log.error("Report input has errors {}", results.getErrors());
            bag.stopProcessing(String.format("Report input has errors %s", results.getErrors()));
        }
    }

    private <T> Result<Boolean, XMLSyntaxError> validate(T object) {
        CollectingErrorEventHandler h = new CollectingErrorEventHandler();
        String result = this.conversionService.writeXml(object, this.schema, h);
        return new Result<Boolean, XMLSyntaxError>(StringUtils.isNotBlank((CharSequence)result), h.getErrors());
    }

    @Generated
    public ValidateReportInputAction(ConversionService conversionService, Schema schema) {
        this.conversionService = conversionService;
        this.schema = schema;
    }
}

