/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.xml;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.trans.XPathException;

public class RelativeUriResolver
implements URIResolver,
UnparsedTextURIResolver {
    private final URI baseUri;

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        URI resolved = RelativeUriResolver.resolve(URI.create(href), URI.create(base));
        if (this.isUnderBaseUri(resolved)) {
            try {
                return new StreamSource(resolved.toURL().openStream(), resolved.toASCIIString());
            }
            catch (IOException e) {
                throw new TransformerException(String.format("Can not resolve required  %s", href), e);
            }
        }
        throw new TransformerException(String.format("The resolved transformation artifact %s is not within the configured repository %s", resolved, this.baseUri));
    }

    public static URI resolve(URI href, URI base) {
        boolean jarURI = RelativeUriResolver.isJarURI(base);
        URI tmpBase = jarURI ? URI.create(base.toASCIIString().substring(4)) : base;
        URI result = tmpBase.resolve(href);
        return jarURI ? URI.create("jar:" + result.toString()) : result;
    }

    static boolean isJarURI(URI uri) {
        return uri.isOpaque() && uri.getScheme().equals("jar");
    }

    private boolean isUnderBaseUri(URI resolved) {
        return RelativeUriResolver.isUnderBaseUri(resolved, this.baseUri);
    }

    private static boolean isUnderBaseUri(URI resolved, URI baseUri) {
        if (resolved == null || baseUri == null) {
            return false;
        }
        String base = baseUri.toASCIIString().replaceAll("file:/+", "");
        String r = resolved.toASCIIString().replaceAll("file:/+", "");
        return r.startsWith(base);
    }

    public Reader resolve(URI absoluteURI, String encoding, Configuration config) throws XPathException {
        if (RelativeUriResolver.isUnderBaseUri(absoluteURI, this.baseUri)) {
            return new StandardUnparsedTextResolver().resolve(absoluteURI, encoding, config);
        }
        throw new XPathException(String.format("The resolved transformation artifact %s is not within the configured repository %s", absoluteURI, this.baseUri));
    }

    @Generated
    public RelativeUriResolver(URI baseUri) {
        this.baseUri = baseUri;
    }
}

